function [x_crop,y_crop,roi_crop_0,roi_crop_nan,boundingBox_roi] = crop_3D_mesh(roi_rough,x_down,y_down,roi_nan)

% This function is used to tightly crop the roi from the image
%% input
% roi_rough- binary mask of the roi - has same size as roi_nan
% x_down - x axis values for the input image
% y_down - y axis values for the input image
% roi_nan - roi with the original image values

%% output
% 3D mesh can be plotted
% x_crop- cropped x-axis
% y_crop- cropped y-axis
% roi_crop_0- tightly cropped binarized mask of cartridge case roi
% roi_crop_nan- tightly cropped binarized mask of cartridge case roi with
%               zeros replaced by nan values
% boundingBox_roi- Bounding box of the roi w.r.t. the whole cartridge case
%                 image

T=roi_rough;
z=roi_nan;
Rx=sum(T,2);
Ry=sum(T,1);

Rx(Rx>0)=1;
Ry(Ry>0)=1;

%Xx=X.*Rx;
%Yy=Y.*Ry;

K1=bwconncomp(T,8); % Include only 8-connected components
L1=regionprops(K1,'all');
f1=cat(1,L1(:).Solidity); % solidity based selection of ROI
[CC1 UU1]=max(f1);
Xmin1=min(L1(UU1,1).PixelList(:,1));
Xmax1=max(L1(UU1,1).PixelList(:,1));
Ymin1=min(L1(UU1,1).PixelList(:,2));
Ymax1=max(L1(UU1,1).PixelList(:,2));
Width1=Xmax1-Xmin1;
Height1=Ymax1-Ymin1;

% Crop segmented region from Image
roi_crop_0=imcrop(z,[Xmin1 Ymin1 Width1 Height1]);
% figure;
% imshow(U1,[])

[xX yY vV]=find(Rx>0,1,'first');
[xX1 yY1 vV1]=find(Rx>0,1,'last');

[xX2 yY2 vV2]=find(Ry>0,1,'first');
[xX3 yY3 vV3]=find(Ry>0,1,'last');

%y_crop=(x_down(yY2:yY3))';
%x_crop=(y_down(xX:xX1))';
x_crop=(x_down(xX:xX1));
y_crop=(y_down(yY2:yY3));

roi_crop_nan=double(roi_crop_0);
roi_crop_nan(roi_crop_nan==0)=NaN;
boundingBox_roi=[Xmin1 Ymin1 Width1 Height1];
%  figure;
%  h1=surfc(x_crop,y_crop,roi_crop_nan);
%  set(h1,'edgecolor','none');
end

